---
obsidianUIMode: preview
---

Zone-based combat can help GMs run fast, dynamic, and high-action combat without worrying about all the details of tactical combat played out on a grid. It supports multiple combat styles, including pure narrative theater-of-the-mind combat, quickly drawn abstract sketches, or miniatures used with detailed maps or 3D terrain. Using zone-based combat means you have to worry less about the details of a 5-foot-per-square grid and can focus more on big heroic action. Zone-based combat simply requires that the GM and the players work together with the shared goal of creating fantastic stories of high adventure.

## Zone Rules

The following guidelines establish the broad strokes of zone-based combat:

* Combat areas are made up of one or more zones, each of which is roughly 25 feet on a side but which can be any size.
* The GM defines zones using evocative descriptions, such as "a crumbling bridge over a bottomless gorge," "a blood-covered altar," or "a holy statue of light."
* The GM can write down or define these zones and their descriptions on paper, note cards, or erasable battle maps so the players can visualize the situation. Miniatures or tokens can mark out the positions of characters and monsters in zones.
* Players are encouraged to make use of features in a zone, whether by taking cover, climbing to an advantageous position, activating magical locations, and so forth.
* Most combat encounters occur in a single zone. Big battles might use two or more zones.
* On each of their turns, a character can move within a zone or can move from one zone to another. Characters with extra movement can move up to two zones away.
* Assume that all creatures in combat move cautiously, avoiding opportunity attacks when possible. The GM informs the players if a character risks an opportunity attack from their intended activity in the fight.
* Attacks with a range of 25 feet or greater can target creatures within a zone or one zone away.
* Attacks with a range of 50 feet or greater can also target creatures two or more zones away.
* If a character attacks with or is attacked by a melee attack with a 5-foot reach, that character will provoke opportunity attacks if they attempt to move away from their opponent. A character attacked by a melee attack with a 5-foot reach also has disadvantage on ranged attacks.
* Players can make best use of zone-based combat by describing their intent — for example, "I want to attack the orc chief with my glaive but stay out of his reach," or "I want to get between our wizard and the ogre."
* The GM then works with the players to help them achieve their intent.

## Areas of Effect in Zones

Many spells and features have areas of effect. GMs can use the following guidelines to adjudicate which targets are hit by such effects. These guidelines break out general descriptions of the size of an area of effect, how many creatures are typically affected in that area using zone-based combat, and examples of common spells and class features that use that size:

* **Tiny Area:** One or two creatures in the same zone (*cloud of daggers*)
* **Small Area:** Two or three creatures in the same zone (*burning hands*, *thunderwave*)
* **Large Area:** Four to six creatures in the same zone (*cone of cold*, *fireball*)
* **Huge Area:** Twelve creatures across two zones (*circle of death*, Turn Undead)
* **Short Line:** Two or three creatures in the same zone (*wall of fire*)
* **Large Line:** Two to four creatures across two zones (*lightning bolt*)

GMs can adjudicate and adjust these numbers based on the current situation. For example, an area containing a horde of monsters might double the potential number of monsters affected. Whatever the circumstances, though, a GM should always adjudicate in favor of the characters.

## Handling Edge Cases

Zone-based combat doesn't account for a wide range of features that make use of specific distances. In those cases, it's up to the GM to work with a player's intent to help them make use of those features. In all cases, the GM should ask what the player wants to do, then help them figure out how to do it.
